#!/usr/bin/env python3

import os
import sys
import argparse

from pathlib import Path

filedir = Path(os.path.dirname(__file__)).resolve()
if list(filedir.glob('ext/*tachyon.*')):
    sys.path.insert(0, (filedir / 'ext').as_posix())

import tachyon

parser = argparse.ArgumentParser()
parser.add_argument('-o', dest='output', default=None)

options = parser.parse_args(sys.argv[1:])

result = tachyon.phaserize('shoot')

if options.output:
    with open(options.output, 'w') as f:
        f.write('success')

if not isinstance(result, int):
    print('Returned result not an integer.')
    sys.exit(1)

if result != 1:
    print('Returned result {} is not 1.'.format(result))
    sys.exit(1)
